max_entities = 100;
entities = new Array();

for (var i=0;i<max_entities;i++)
{
	entities[i] = Object();
  entities[i].active = false;
	entities[i].x = 0;
	entities[i].y = 0;
	entities[i].vx = 0;
	entities[i].vy = 0;
	entities[i].direction = "east";
	entities[i].frame = 0;
	entities[i].type = 0
	entities[i].name = 'ent'+i;
	entities[i].spriteset = "mainchar.rss";
	entities[i].face = 1
	entities[i].grab = -1;
	entities[i].grabbed = -1;

}


ENTITY_LAYER = 2
PLAYER_LAYER = 3;



entities[0].active = true;

max_types = 5;
types = new Array();
for (var i=0;i<max_types;i++)
{
	types[i] = Object();
	types[i].has_physics = true;
	types[i].person_obstruct = true;//respects tile obstructions
	types[i].tile_obstruct = true;//is a obstruction to persons
	types[i].has_gravity = true;
	types[i].spriteset = ""
	types[i].yoffset = 0
	types[i].xoffset = 0;
	types[i].timer = 0;
}

types[0].spriteset = 'mainchar.rss';
types[0].has_physics = true;
types[0].person_obstruct = true;
types[0].tile_obstruct = true;
types[0].has_gravity = true;
types[0].yoffset = -10;
types[0].xoffset = -3;
types[0].sx_off = 8;
types[0].sy_off = 7;
types[0].friction_multi = 1;

types[1].spriteset = 'block.rss';
types[1].has_physics = true;
types[1].person_obstruct = true;
types[1].tile_obstruct = true;
types[1].has_gravity = true;
types[1].yoffset = -3;
types[1].xoffset = -3;
types[1].sx_off = 8;
types[1].sy_off = 8;
types[1].friction_multi = 3;

types[2].spriteset = 'bomb.rss';
types[2].has_physics = true;
types[2].person_obstruct = true;
types[2].tile_obstruct = true;
types[2].has_gravity = true;
types[2].yoffset = -2;
types[2].xoffset = -3;
types[2].sx_off = 0;
types[2].sy_off = 3;
types[2].friction_multi = 1;


types[3].spriteset = 'thropy.rss';
types[3].has_physics = true;
types[3].person_obstruct = false;
types[3].tile_obstruct = true;
types[3].has_gravity = true;
types[3].yoffset = -2;
types[3].xoffset = -3;
types[3].sx_off = 0;
types[3].sy_off = 0;
types[3].friction_multi = 1;


types[4].spriteset = 'gold.rss';
types[4].has_physics = true;
types[4].person_obstruct = false;
types[4].tile_obstruct = false;
types[4].has_gravity = true;
types[4].yoffset = -2;
types[4].xoffset = -3;
types[4].sx_off = 0;
types[4].sy_off = 0;
types[4].friction_multi = 1;


spriteset_to_type = new Object();

for (var i=0;i<max_types;i++)
{
	if (types[i].spriteset != "")
	{
		spriteset_to_type[types[i].spriteset] = i;
	}
}


function AddNewEntity(x,y,vx,vy, direction, frame, type, name, spriteset, face)
{

	for (var j=0;j<max_entities;j++)
	{
		if (entities[j].active == false)
		{
			entities[j].active = true;
			entities[j].x = x;
			entities[j].y = y;
			entities[j].vx = vx;
			entities[j].vy = vy;
			entities[j].direction = direction;
			entities[j].frame = frame;
			entities[j].type = type;
			entities[j].name = name;
			entities[j].spriteset = spriteset;
			entities[j].face = face;
			entities[j].grab = -1;
			entities[j].grabbed = -1;
			entities[j].timer = 0
			return
		}
	}

}


function ResetEntities(reset_player)
{
	start = 1;
	if (reset_player)
	{
		start = 0;
	}

	for (var i=start;i<max_entities;i++)
	{	
		if (reset_player == true || entities[i].grabbed == -1)
		{
			entities[i].active = false;
		}
	}
}

function UpdateEntities()
{
	for (var i=0;i<max_entities;i++)
	{
		if (entities[i].active)
		{
			//update physics
			//check boundaries
			//update frames
			//update AI (if applicable)

			if (types[entities[i].type].has_physics)
			{
			
				UpdatePhysicsForEntity(i);
			}
			UpdateBomb(i);
			UpdateFramesForEntity(i);
			if (i==0)
			{
				GetPlayerInput();
			}
			else
			{
				UpdateAI(i);
			}
		}
	}
	UpdateGlitters();
}

g_gravity = 0.25;
g_max_gravity_speed = 7;
JUMP_SPEED = -6.7
FRICTION_CONSTANT = 0.1
MOMENTUM_X = 0.2;
MAX_MOMENTUM = 2;

function UpdatePhysicsForEntity(i)
{

	if (entities[i].type ==2 &&entities[i].timer > bomb_frames)
	{
		return
	}

	if (entities[i].grabbed > -1)
	{
		k = entities[i].grabbed
		entities[i].x = entities[k].x+16*entities[k].face;
		entities[i].y = entities[k].y;
	}
	else
	{
		t = IsEntityObstructed(i, entities[i].x, entities[i].y)
	
		sx = entities[i].x;
		sy = entities[i].y;
	
		if (types[entities[i].type].has_gravity && entities[i].vy < g_max_gravity_speed)
		{
			entities[i].vy += g_gravity;
		}  
		speed = Math.sqrt(entities[i].vx*entities[i].vx+entities[i].vy*entities[i].vy)
		entities[i].x+=entities[i].vx;
		entities[i].y+=entities[i].vy;
		if (types[entities[i].type].tile_obstruct || types[entities[i].type].person_obstruct)
		{
			if (IsEntityObstructed(i, entities[i].x, entities[i].y))
			{
					entities[i].x-=entities[i].vx;
					entities[i].y-=entities[i].vy;
					if (IsEntityObstructed(i, entities[i].x+entities[i].vx, entities[i].y))
					{
						entities[i].vx = 0
						BombCheck(i, speed)
					}
					if (IsEntityObstructed(i, entities[i].x, entities[i].y+entities[i].vy))
					{
						for (j=Math.floor(entities[i].vy);j>=0;j--)
						{
							if (!IsEntityObstructed(i, entities[i].x, entities[i].y+j))
							{
								entities[i].y = entities[i].y+j;
								break
							}
						}
						if (entities[i].vy> 2)
							SoundFallCheck(i, speed);
						entities[i].vy = 0
						BombCheck(i, speed)
					} 
						
					if (!IsEntityObstructed(i, entities[i].x+entities[i].vx, entities[i].y+entities[i].vy))
					{
						entities[i].x += entities[i].vx;
						entities[i].y += entities[i].vy;     
					}
					else//entity's on a corner
					{
						entities[i].vx = 0;
						entities[i].vy = 0
						BombCheck(i, speed)
					}
	
			}	
			entities[i].x = Math.round(entities[i].x);
			entities[i].y = Math.round(entities[i].y);	
			
	
			
			
			if (IsEntityOnGround(i))
			{
				//apply friction now:
				if (Math.abs(entities[i].vx) > 0)
				{
					entities[i].vx -= Math.sign(entities[i].vx)*FRICTION_CONSTANT*types[entities[i].type].friction_multi;
					if (Math.abs(entities[i].vx) < FRICTION_CONSTANT*types[entities[i].type].friction_multi)
					{
						entities[i].vx = 0;
					}
				}
				CheckForSwitches(i);
			}
		}
	
		s = IsEntityObstructed(i, entities[i].x, entities[i].y)
		if (s)
		{
			for (var k=0;k<off_checks.length;k++)
			{
	
				if (!IsEntityObstructed(i, entities[i].x+off_checks[k].x, entities[i].y+off_checks[k].y))
				{
					entities[i].x+=off_checks[k].x
					entities[i].y+=off_checks[k].y

				}
			}
		}
	}
}

function SoundFallCheck(i, speed)
{
	if (speed > 1)
	{
		if (i == 0 && speed > 2 )
		{
			PlaySound(3)
		}
		else if (entities[i].type == 1 || entities[i].type == 2)
		{
			PlaySound(6)
		}
	}
}

function BombCheck(i, speed)
{
	if (speed > 1.5)
	{
		if (entities[i].type == 2 && entities[i].active && entities[i].timer == 0)
		{
			LightBomb(i);
		}
	}
}

off_checks = new Array();
off_checks[0] = {"x": -2, "y": 0}
off_checks[1] = {"x": 2, "y": 0}
off_checks[2] = {"x": 0, "y": -2}
off_checks[3] = {"x": 0, "y": 2}
off_checks[4] = {"x": 2, "y": 2}
off_checks[5] = {"x": -2, "y": 2}
off_checks[6] = {"x": 2, "y": -2}
off_checks[7] = {"x": -2, "y": -2}


function UpdateEntityObstructions(i)
{
	

}

function IsEntityObstructed(i, x, y)
{
	//Get the person obstructions here.
	if (types[entities[i].type].person_obstruct)
	{
		res_person = false;
		for (var k=0;k<max_entities;k++)
		{
			if (entities[k].active && types[entities[k].type].person_obstruct)
			{
				if (Math.max(Math.abs(x-entities[k].x), Math.abs(y-entities[k].y)) < 16 && k!=i && !(entities[k].grabbed >-1))
				{
						res_person = true;
						break
				}
			}
		}
	}
	else
	{
		res_person = false;
	}
	
	//Get the tile ones here
	if (types[entities[i].type].tile_obstruct)
	{
		old_layer = GetPersonLayer(entities[i].name);
		SetPersonLayer(entities[i].name,0);
		res_tile = IsPersonObstructed(entities[i].name, x,y);
		SetPersonLayer(entities[i].name, old_layer)
	}
	else
	{
		res_tile = false;
	}

	return res_tile || res_person
}

function IsEntityOnGround(i)
{

	if (!IsEntityObstructed(i, entities[i].x, entities[i].y) && IsEntityObstructed(i, entities[i].x, entities[i].y+1))
	{
		return true;
	}
	return false;
}

facer = new Array();
facer[-1] = "west";
facer[1] = "east";


g_frame_update_rate = 4;


function UpdateFramesForEntity(i)
{
//set character person's frame here, as well as position.
	SetPersonX(entities[i].name, entities[i].x*ScaleFactor+types[entities[i].type].xoffset*ScaleFactor);
	SetPersonY(entities[i].name, entities[i].y*ScaleFactor+types[entities[i].type].yoffset*ScaleFactor);

	if (entities[i].type == 2)
	{
		SetPersonDirection(entities[i].name, entities[i].direction);
		SetPersonFrame(entities[i].name, entities[i].frame);
		if (entities[i].timer > bomb_frames)
		{
				SetPersonScaleFactor(entities[i].name, 6,6);
				SetPersonScaleFactor(entities[i].name, 6,6);
				SetPersonX(entities[i].name, entities[i].x*ScaleFactor+types[entities[i].type].xoffset*ScaleFactor-32);
				SetPersonY(entities[i].name, entities[i].y*ScaleFactor+types[entities[i].type].yoffset*ScaleFactor-32);
		}
		return
	}



	if (!IsEntityOnGround(i) && entities[i].vy> 0)
	{
		entities[i].frame = 0;
		entities[i].direction = "jump";
	}
	else if (!IsEntityOnGround(i))
	{
		entities[i].frame = 1;
		entities[i].direction = "jump";
	}
	else
	{
		entities[i].direction = "walk";
		if (g_frames%g_frame_update_rate == 0)
		{
			if (Math.abs(entities[i].vx) >= 1)
			{
				entities[i].frame+=1
			}
			else
			{
				if (entities[i].frame %2 == 1)
				{
					entities[i].frame++;
				}
			}
		}
	}

	grab = ""
	if (entities[i].grab > -1)
	{
		grab = "grab"
	}
	SetPersonDirection(entities[i].name, grab+entities[i].direction+facer[entities[i].face]);
	SetPersonFrame(entities[i].name, entities[i].frame);
	entities[i].frame = GetPersonFrame(entities[i].name);
}


g_space_pressed = false;
g_jumped = false



function GetPlayerInput()
{
	if (entities[0].vy >= 0 || IsEntityOnGround(0))
	{
		g_jumped= false
	}

	if (!IsKeyPressed(KEY_CSPACE))
	{
		g_space_pressed = false
	}
	if (IsKeyPressed(KEY_CLEFT) &&!IsKeyPressed(KEY_CRIGHT)&& !IsEntityObstructed(0, entities[0].x-2, entities[0].y))
	{
		if (Math.abs(entities[0].vx) < MOMENTUM_X)
		{
			entities[0].vx -= 0.25;
		}
		else if (entities[0].vx > -MAX_MOMENTUM)
		{
			entities[0].vx-=MOMENTUM_X;
		}
		
	}
	if (IsKeyPressed(KEY_CRIGHT)&&!IsKeyPressed(KEY_CLEFT)&& !IsEntityObstructed(0, entities[0].x+2, entities[0].y))
	{
		if (Math.abs(entities[0].vx) < MOMENTUM_X)
		{
			entities[0].vx += +0.25;
		}
		else if (entities[0].vx < MAX_MOMENTUM)
		{
			entities[0].vx+=MOMENTUM_X;
		}
	}

	if (g_space_pressed ==false && IsKeyPressed(KEY_CSPACE) && IsEntityOnGround(0))
	{
		entities[0].vy=JUMP_SPEED;
		g_jumped = true;
		g_space_pressed=true;
		PlaySound(2)
	}

  if (g_jumped == true && entities[0].vy < 0 && !IsKeyPressed(KEY_CSPACE))
  {
		entities[0].vy += 4*g_gravity
  }


	if (IsKeyPressed(KEY_CCTRL))
	{
		if (entities[0].grab == -1)
		{
			AttemptGrab(0, entities[0].x, entities[0].y, entities[0].face);
		}
	}
	if (!IsKeyPressed(KEY_CCTRL))
	{
		if (entities[0].grab > 0)
		{
			if (IsKeyPressed(KEY_CUP))
			{
				ThrowGrabbedEntity(0,"up");
			}
			else if (IsKeyPressed(KEY_CDOWN))
			{
				ThrowGrabbedEntity(0,"down");
			}
			else
			{
				ThrowGrabbedEntity(0);
			}
		}
	}

	if (IsKeyPressed(KEY_CLEFT) &&!IsKeyPressed(KEY_CRIGHT))
	{
		entities[0].face = -1;
	}
	else if (IsKeyPressed(KEY_CRIGHT)&&!IsKeyPressed(KEY_CLEFT))
	{
		entities[0].face = 1;
	}

	if (IsKeyPressed(KEY_ESCAPE))
	{
		Exit()
	}
	
	CheckThropyPickup();
	CheckMapTransitions();
}


function AttemptGrab(ent, x, y, face)
{
	pos_x = x+face*16;
	pos_y = y;

	for (var k=0;k<max_entities;k++)
	{
		if (k!= ent && entities[k].active)
		{
			if (Math.max(Math.abs(pos_x-entities[k].x), Math.abs(pos_y-entities[k].y)) < 16)
			{
				if (entities[k].type == 2 && entities[k].timer >= bomb_frames)
				{
				
				}
				else
				{
					entities[ent].grab = k;
					entities[k].grabbed = ent;
					break;
				}
			}
		}
	}
}


function ThrowGrabbedEntity(ent, throw_type)
{
	k = entities[ent].grab;
	if (throw_type == "up")
	{	
		entities[k].vx = entities[ent].vx;
		entities[k].vy = -7;
	}
	else if (throw_type == "down")
	{	
		entities[k].vx = entities[ent].vx;
		entities[k].vy = entities[ent].vy;
	}
	else
	{	
		entities[k].vx = entities[ent].vx+entities[ent].face*2;
		entities[k].vy = -4;
	}
	PlaySound(5);
	entities[k].grabbed = -1;
	entities[ent].grab = -1;
}


function UpdateAI(i)
{
	base_xoffset = 0;
	base_yoffset = -8;
	if (entities[i].type == 3)
	{
		types[3].yoffset = Math.round(base_yoffset+4*Math.sin(2*3.14159*(g_frames%64)/64))
		types[3].xoffset = Math.round(base_xoffset+2*Math.sin(2*3.14159*(g_frames%128)/128))
		if (types[3].xoffset > 0)
		{
			entities[i].face = -1;
		}
		else if (types[3].xoffset < 0)
		{
			entities[i].face = 1;
		}
		if (g_frames%4 == 0)
		{
			if (Math.random() < 0.3)
			{
				AddSparkle(entities[i].x, entities[i].y);
			}
		}
	}
}

function AddSparkle(x,y)
{-8
	x = Math.floor(Math.random()*6+x)+types[3].xoffset
	y = Math.floor(Math.random()*12-4+y)+types[3].yoffset
	for (var i=0;i<max_glitters;i++)
	{
		if (current_glitters[i].active == false)
		{
			current_glitters[i].x = x;
			current_glitters[i].y = y;
			current_glitters[i].frame = -1
			current_glitters[i].active = true
			current_glitters[i].spriteset = Math.floor(3*Math.random())
		}
	}
}

max_glitters = 100
current_glitters = new Array()
for (var i=0;i< max_glitters;i++)
{
	current_glitters[i] = Object();
	current_glitters[i].x = 0;
	current_glitters[i].y = 0;
	current_glitters[i].frame = 0;
	current_glitters[i].spriteset = 0;
	current_glitters[i].active = false;
}

glit_update = 10
glitter_spriteset = new Array();
glitter_spriteset[0]=[LoadImage("sparkle1.png"), LoadImage("sparkle2.png"), LoadImage('sparkle3.png'), LoadImage("sparkle2.png"), LoadImage("sparkle1.png")]
glitter_spriteset[1]=[LoadImage("sparkle1.png"), LoadImage("sparkle4.png"), LoadImage('sparkle5.png'), LoadImage("sparkle6.png"), LoadImage("sparkle7.png"), LoadImage("sparkle1.png")]
glitter_spriteset[2]=[LoadImage("sparkle1.png"), LoadImage("sparkle7.png"), LoadImage("sparkle6.png"), LoadImage('sparkle5.png'), LoadImage("sparkle4.png"), LoadImage("sparkle1.png")]

function UpdateGlitters()
{
	for (i=0;i<max_glitters;i++)
	{
		if (current_glitters[i].active == true)
		{
			if (g_frames%glit_update == 0)
			{
				current_glitters[i].frame++;
				if (current_glitters[i].frame >= glitter_spriteset[current_glitters[i].spriteset].length)
				{
					current_glitters[i].active = false;
				}
			}
		}
	}
}

function DrawGlitters()
{
	for (var i=0;i<max_glitters;i++)
	{
		if (current_glitters[i].active == true && current_glitters[i].frame > -1)
		{
			x = MapToScreenX(0, current_glitters[i].x)*2
			y = MapToScreenY(0, current_glitters[i].y)*2
			glitter_spriteset[current_glitters[i].spriteset][current_glitters[i].frame].zoomBlit(x,y, 2)
		}
	}
}

thropies_found = new Object();
//format is thropies_found[level_number] = 1.  Length gives total.

thropies_found[6] = 0//1
thropies_found[10] = 0//1
thropies_found[15] = 0//1
thropies_found[19] = 0//1
thropies_found[20] = 0//1
thropies_found[24] = 0//1
thropies_found[29] = 0//1
thropies_found[30] = 0//1
thropies_found[36] = 0//1

function CheckThropyPickup()
{
	for (var k=1;k<max_entities;k++)
	{
		if (entities[k].type == 3 && entities[k].active == true)
		{
		
			if (Math.max(Math.abs(entities[k].x-entities[0].x), Math.abs(entities[k].y-entities[0].y)) < 6)
			{
				//pickup this thropy.
				entities[k].active = false;
				entities[k].x = 0
				entities[k].y = 0
				DestroyPerson(entities[k].name);
				PlaySound(8);
				if (thropies_found[g_current_level] == 0)
				{
					thropies_found[g_current_level] = 1
					HandleLastScreen();
				}
			}
		}
	}
}
